/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.providers.query.mql;

import antlr.RecognitionException;
import antlr.collections.AST;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.makumba.DataDefinition;
import org.makumba.FieldDefinition;
import org.makumba.MakumbaError;
import org.makumba.OQLParseError;
import org.makumba.ProgrammerError;
import org.makumba.commons.NameResolver;
import org.makumba.providers.Configuration;
import org.makumba.providers.DataDefinitionProvider;
import org.makumba.providers.QueryAnalysis;
import org.makumba.providers.QueryProvider;
import org.makumba.providers.SQLQueryGenerator;
import org.makumba.providers.query.mql.ASTUtil;
import org.makumba.providers.query.mql.FunctionInliner;
import org.makumba.providers.query.mql.HqlParser;
import org.makumba.providers.query.mql.MqlQueryAnalysisProvider;
import org.makumba.providers.query.mql.MqlSqlGenerator;
import org.makumba.providers.query.mql.MqlSqlWalker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MqlQueryAnalysis
implements QueryAnalysis,
SQLQueryGenerator {
    public static final String MAKUMBA_PARAM = "param";
    private String query;
    protected DataDefinition insertIn;
    private List<String> parameterOrder = new ArrayList<String>();
    private DataDefinition proj;
    private boolean noFrom = false;
    private LinkedHashMap<String, DataDefinition> labels;
    private Hashtable<String, String> aliases;
    private DataDefinition paramInfo;
    private AST analyserTreeOriginal;
    private AST analyserTreeSQL;
    private NameResolver.TextList text;
    private MqlSqlWalker analyser;
    protected Vector<String> generatedLabels = new Vector();
    public static final String regExpInSET = "in[\\s]+set[\\s]*\\(";
    public static final Pattern patternInSet = Pattern.compile("in[\\s]+set[\\s]*\\(");
    private int labelCounter = 0;
    private Map<String, Object> arguments;
    DataDefinition expandedParamInfo = null;

    static String formatQueryAndInsert(String query, String insertIn) {
        if (insertIn != null && insertIn.length() > 0) {
            return "###" + insertIn + "###" + query;
        }
        return query;
    }

    public MqlQueryAnalysis(String queryAndInsert, boolean optimizeJoins, boolean autoLeftJoin) {
        MqlSqlWalker mqlAnalyzer;
        Date d = new Date();
        if (queryAndInsert.startsWith("###")) {
            this.insertIn = DataDefinitionProvider.getInstance().getDataDefinition(queryAndInsert.substring(3, queryAndInsert.indexOf(35, 3)));
            this.query = queryAndInsert.substring(queryAndInsert.indexOf(35, 3) + 3);
        } else {
            this.query = queryAndInsert;
        }
        this.query = MqlQueryAnalysis.preProcess(this.query);
        if (this.query.toLowerCase().indexOf("from") == -1) {
            this.noFrom = true;
            this.query = this.query + " FROM org.makumba.db.makumba.Catalog c";
        }
        AST parsed = null;
        if (!Configuration.getQueryInliner().equals("tree")) {
            HqlParser parser = null;
            try {
                parser = HqlParser.getInstance(this.query);
                parser.statement();
            }
            catch (Throwable t) {
                this.doThrow(t, parser != null ? parser.getAST() : null);
            }
            this.doThrow(parser.error, parser.getAST());
            parsed = parser.getAST();
        } else {
            parsed = FunctionInliner.inlineQueryTree(this.query);
        }
        MqlQueryAnalysisProvider.transformOQLParameters(parsed, this.parameterOrder);
        MqlQueryAnalysisProvider.transformOQL(parsed);
        this.analyser = mqlAnalyzer = new MqlSqlWalker(this.query, this.insertIn, optimizeJoins, autoLeftJoin, false);
        try {
            mqlAnalyzer.statement(parsed);
        }
        catch (Throwable e) {
            this.doThrow(e, parsed);
        }
        this.doThrow(mqlAnalyzer.error, parsed);
        this.analyserTreeOriginal = mqlAnalyzer.getAST();
        this.labels = mqlAnalyzer.rootContext.labels;
        this.aliases = mqlAnalyzer.rootContext.aliases;
        this.paramInfo = DataDefinitionProvider.getInstance().getVirtualDataDefinition("Parameters for " + this.query);
        this.proj = DataDefinitionProvider.getInstance().getVirtualDataDefinition("Projections for " + this.query);
        mqlAnalyzer.setProjectionTypes(this.proj);
        for (int i = 0; i < this.parameterOrder.size(); ++i) {
            FieldDefinition fd = mqlAnalyzer.paramInfoByPosition.getFieldDefinition(MAKUMBA_PARAM + i);
            if (fd == null && !mqlAnalyzer.multiTypeParams.contains(this.parameterOrder.get(i))) {
                fd = mqlAnalyzer.paramInfoByName.getFieldDefinition(this.parameterOrder.get(i));
            }
            if (this.parameterOrder.get(i).startsWith("actor_")) {
                String type = this.parameterOrder.get(i).substring(6).replaceAll("_", ".");
                fd = mqlAnalyzer.ddp.getDataDefinition(type).getFieldDefinition(0);
            }
            if (fd == null) {
                throw new MakumbaError("Panic: could not compute type of parameter at position " + i + " with name '" + this.parameterOrder.get(i) + "' of query " + this.getQuery());
            }
            this.paramInfo.addField(DataDefinitionProvider.getInstance().makeFieldWithName(MAKUMBA_PARAM + i, fd));
        }
        long diff = new Date().getTime() - d.getTime();
        Logger.getLogger("org.makumba.db.query.compilation").fine("MQL analysis: " + diff + " ms: " + this.query);
    }

    protected void doThrow(Throwable t, AST debugTree) {
        RecognitionException re;
        if (t == null) {
            return;
        }
        if (t instanceof RuntimeException) {
            t.printStackTrace();
            throw (RuntimeException)t;
        }
        String errorLocation = "";
        String errorLocationNumber = "";
        if (t instanceof RecognitionException && (re = (RecognitionException)t).getColumn() > 0) {
            errorLocationNumber = " column " + re.getColumn() + " of ";
            StringBuffer sb = new StringBuffer();
            sb.append("\r\n");
            for (int i = 0; i < re.getColumn(); ++i) {
                sb.append(' ');
            }
            sb.append('^');
            errorLocation = sb.toString();
        }
        throw new OQLParseError("\r\nin " + errorLocationNumber + " query:\r\n" + this.query + errorLocation + errorLocation + errorLocation, t);
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public DataDefinition getLabelType(String labelName) {
        String s1 = this.aliases.get(labelName);
        if (s1 != null) {
            labelName = s1;
        }
        return this.labels.get(labelName);
    }

    @Override
    public Map<String, DataDefinition> getLabelTypes() {
        return this.labels;
    }

    @Override
    public DataDefinition getParameterTypes() {
        return this.expandedParamInfo;
    }

    @Override
    public DataDefinition getProjectionType() {
        return this.proj;
    }

    private String getFrom() {
        String[] splitAtFrom = this.query.split("\\s[f|F][r|R][o|O][m|M]\\s");
        String[] splitAtWhere = splitAtFrom[1].split("\\s[w|W][h|H][e|E][r|R][e|E]\\s");
        return splitAtWhere[0];
    }

    public String getFieldOfExpr(String expr) {
        if (expr.indexOf(".") > -1) {
            return expr.substring(expr.lastIndexOf(".") + 1);
        }
        return expr;
    }

    public DataDefinition getTypeOfExprField(String expr) {
        DataDefinition result;
        if (expr.indexOf(".") == -1) {
            return this.getLabelType(expr);
        }
        int lastDot = expr.lastIndexOf(".");
        String beforeLastDot = expr.substring(0, lastDot);
        if (beforeLastDot.indexOf(".") == -1) {
            result = this.getLabelType(beforeLastDot);
        } else {
            String dummyQuery = "SELECT " + beforeLastDot + " AS projection FROM " + this.getFrom();
            result = QueryProvider.getQueryAnalzyer("OQL").getQueryAnalysis(dummyQuery).getProjectionType().getFieldDefinition("projection").getPointedType();
        }
        return result;
    }

    public static String showAst(AST ast) {
        return ast.toStringTree();
    }

    static boolean isNil(AST a) {
        return a.getType() == 120 && a.getText().toUpperCase().equals("NIL");
    }

    static void setNullTest(AST a) {
        if (a.getType() == 97) {
            a.setType(77);
            a.setText("is null");
        } else {
            a.setType(76);
            a.setText("is not null");
        }
    }

    public static String preProcess(String query) {
        query = query.replaceAll("->", "__");
        Matcher m = patternInSet.matcher(query.toLowerCase());
        while (m.find()) {
            int start = m.start();
            int beginSet = m.group().indexOf("set");
            query = query.substring(0, start + beginSet) + "   " + query.substring(start + beginSet + 3);
        }
        query = query.replaceAll("IN SET", "IN    ");
        return query;
    }

    public String createLabel() {
        String l = "_x_gen_" + this.labelCounter++;
        this.generatedLabels.add(l);
        return l;
    }

    @Override
    public void setArguments(Map<String, Object> arguments) {
        this.arguments = arguments;
        this.analyserTreeSQL = this.analyser.fact.dupTree(this.analyserTreeOriginal);
        this.expandMultipleParameters();
    }

    @Override
    public int getSQLArgumentNumber() {
        if (this.expandedParamInfo == null) {
            throw new MakumbaError("Can't call this method without having set the arguments with setArguments!");
        }
        return this.expandedParamInfo.getFieldNames().size();
    }

    @Override
    public DataDefinition getSQLQueryArgumentTypes() {
        return this.expandedParamInfo;
    }

    @Override
    public String getSQLQuery(NameResolver nr) {
        if (this.arguments == null && this.expandedParamInfo != null) {
            throw new MakumbaError("Error: you cannot ask for the unexpanded SQL query after having already called it when providing arguments");
        }
        MqlSqlGenerator mg = new MqlSqlGenerator();
        try {
            mg.statement(this.analyserTreeSQL);
        }
        catch (Throwable e) {
            this.doThrow(e, this.analyserTreeSQL);
        }
        this.doThrow(mg.error, this.analyserTreeSQL);
        this.text = mg.text;
        String sql = this.text.toString(nr);
        if (this.noFrom) {
            return sql.substring(0, sql.toLowerCase().indexOf("from")).trim();
        }
        return sql;
    }

    @Override
    public Object[] getSQLQueryArguments() {
        if (this.arguments == null) {
            throw new MakumbaError("Error: arguments should have been set before calling getSQLQueryArguments using setArguments");
        }
        ArrayList<Object> res = new ArrayList<Object>();
        Iterator<String> e = this.parameterOrder.iterator();
        while (e.hasNext()) {
            Object o = this.getArgumentValue(e.next(), this.arguments);
            if (o instanceof List) {
                List v = (List)o;
                for (int i = 1; i <= v.size(); ++i) {
                    res.add(v.get(i - 1));
                }
                continue;
            }
            res.add(o);
        }
        return res.toArray();
    }

    private void expandMultipleParameters() throws ProgrammerError {
        this.expandedParamInfo = DataDefinitionProvider.getInstance().getVirtualDataDefinition("SQL parameters for " + this.query);
        ArrayList<AST> queryParams = this.findQueryParameters(this.analyserTreeSQL, new ArrayList<AST>());
        for (int i = 0; i < this.parameterOrder.size(); ++i) {
            Object val = this.getArgumentValue(this.parameterOrder.get(i), this.arguments);
            if (val instanceof List) {
                List v = (List)val;
                AST qp = queryParams.get(i);
                AST next = qp.getNextSibling();
                for (int j = 0; j < v.size() - 1; ++j) {
                    qp.setNextSibling(ASTUtil.create(this.analyser.fact, 142, "?"));
                    qp = qp.getNextSibling();
                    if (j != v.size() - 1) continue;
                    qp.setNextSibling(next);
                }
                for (int k = 0; k < v.size(); ++k) {
                    FieldDefinition fd = this.paramInfo.getFieldDefinition(i);
                    this.expandedParamInfo.addField(DataDefinitionProvider.getInstance().makeFieldWithName(fd.getName() + "_" + k, fd));
                }
                continue;
            }
            this.expandedParamInfo.addField(this.paramInfo.getFieldDefinition(i));
        }
    }

    private Object getArgumentValue(String argumentName, Map<String, Object> arguments) throws ProgrammerError {
        Object val;
        if (arguments == null) {
            throw new MakumbaError("Empty arguments provided");
        }
        if (argumentName == null) {
            throw new MakumbaError("Empty argumentName provided");
        }
        if (argumentName.startsWith(MAKUMBA_PARAM)) {
            argumentName = argumentName.substring(MAKUMBA_PARAM.length());
            int n = Integer.parseInt(argumentName);
            argumentName = "" + (n + 1);
        }
        if (argumentName.indexOf("###") > 0) {
            argumentName = argumentName.substring(0, argumentName.indexOf("###"));
        }
        if ((val = arguments.get(argumentName)) == null) {
            throw new ProgrammerError("The parameter '" + argumentName + "' should not be null");
        }
        return val;
    }

    private ArrayList<AST> findQueryParameters(AST tree, ArrayList<AST> result) {
        if (tree == null) {
            return result;
        }
        if (tree.getType() == 142) {
            result.add(tree);
        }
        this.findQueryParameters(tree.getFirstChild(), result);
        this.findQueryParameters(tree.getNextSibling(), result);
        return result;
    }

    public static void main(String[] args) {
        MqlQueryAnalysis qA = new MqlQueryAnalysis("SELECT i.name, $actor_test_Individual FROM test.Individual i WHERE i.surname=$surname and i.name = $2", false, true);
        HashMap<String, Object> arguments = new HashMap<String, Object>();
        Vector<String> test = new Vector<String>();
        test.add("la");
        test.add("la");
        test.add("la");
        arguments.put("actor_test_Individual", test);
        arguments.put("surname", "john");
        arguments.put("2", "stuff");
        qA.setArguments(arguments);
        String sql = qA.getSQLQuery(new NameResolver());
        System.out.println("QUERY: " + sql);
        Object[] arg = qA.getSQLQueryArguments();
        System.out.println("ARGS: " + Arrays.toString(arg));
        System.out.println("SIZE: " + qA.getSQLArgumentNumber());
        System.out.println("TYPES: + " + qA.getSQLQueryArgumentTypes());
        for (String n : qA.getSQLQueryArgumentTypes().getFieldNames()) {
            System.out.println(qA.getSQLQueryArgumentTypes().getFieldDefinition(n));
        }
    }
}

