/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.providers.query.mql;

import antlr.ASTFactory;
import antlr.RecognitionException;
import antlr.SemanticException;
import antlr.collections.AST;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.lang.ArrayUtils;
import org.makumba.DataDefinition;
import org.makumba.FieldDefinition;
import org.makumba.MakumbaError;
import org.makumba.ProgrammerError;
import org.makumba.commons.NameResolver;
import org.makumba.providers.DataDefinitionProvider;
import org.makumba.providers.query.mql.ASTUtil;
import org.makumba.providers.query.mql.FunctionCall;
import org.makumba.providers.query.mql.MQLFunctionArgument;
import org.makumba.providers.query.mql.MQLFunctionDefinition;
import org.makumba.providers.query.mql.MqlDotNode;
import org.makumba.providers.query.mql.MqlIdentNode;
import org.makumba.providers.query.mql.MqlNode;
import org.makumba.providers.query.mql.MqlQueryAnalysis;
import org.makumba.providers.query.mql.MqlSqlASTFactory;
import org.makumba.providers.query.mql.MqlSqlBaseWalker;
import org.makumba.providers.query.mql.QueryContext;

public class MqlSqlWalker
extends MqlSqlBaseWalker {
    private static final String LINK_FUNCTION_DEF = "http://www.makumba.org/makumba-spec.html#tab_ql";
    DataDefinitionProvider ddp = DataDefinitionProvider.getInstance();
    ASTFactory fact;
    RecognitionException error;
    QueryContext currentContext;
    private boolean fromEnded;
    static PrintWriter pw = new PrintWriter(System.out);
    DataDefinition paramInfoByPosition;
    DataDefinition paramInfoByName;
    Set<String> multiTypeParams = new HashSet<String>();
    private AST select;
    QueryContext rootContext;
    LinkedHashMap<String, FunctionCall> orderedFunctionCalls = new LinkedHashMap();
    boolean hasSubqueries;
    String query;
    boolean optimizeJoins;
    boolean autoLeftJoin;
    private DataDefinition insertIn;

    public MqlSqlWalker(String query, DataDefinition insertIn, boolean optimizeJoins, boolean autoLeftJoin, boolean functionAsInliner) {
        this.query = query;
        this.functionAsInliner = functionAsInliner;
        this.insertIn = insertIn;
        this.optimizeJoins = optimizeJoins;
        this.autoLeftJoin = autoLeftJoin;
        this.fact = new MqlSqlASTFactory(this);
        this.setASTFactory(this.fact);
        this.paramInfoByPosition = DataDefinitionProvider.getInstance().getVirtualDataDefinition("Temporary parameters by order for " + query);
        this.paramInfoByName = DataDefinitionProvider.getInstance().getVirtualDataDefinition("Temporary parameters by name for " + query);
    }

    public void reportError(RecognitionException e) {
        if (this.error == null) {
            this.error = e;
        }
    }

    public void reportError(String s) {
        if (this.error == null) {
            this.error = new RecognitionException(s);
        }
    }

    protected String inlineFunction(AST functionCall, boolean inFunctionCall) throws SemanticException {
        DataDefinition.QueryFragmentFunction funct;
        DataDefinition type;
        String name;
        AST functionNode = functionCall.getFirstChild();
        AST exprList = functionNode.getNextSibling();
        MqlNode paramNode = (MqlNode)exprList.getFirstChild();
        String path = name = functionNode.getText();
        String additionalPath = name;
        int d = name.lastIndexOf(".");
        if (d > -1) {
            additionalPath = path = name.substring(0, d);
            name = name.substring(d + 1);
            String label = "";
            int d1 = path.indexOf(".");
            if (d1 > -1) {
                label = path.substring(0, d1);
                additionalPath = additionalPath.substring(d1 + 1);
            } else {
                label = path;
                additionalPath = "";
            }
            type = this.rootContext.labels.get(label);
            if (type == null && this.currentContext != null) {
                type = this.currentContext.labels.get(label);
            }
            additionalPath = additionalPath + (additionalPath.length() == 0 ? "" : ".") + name;
        } else {
            type = this.rootContext.labels.get(name);
        }
        if (type == null) {
            type = this.rootContext.labels.values().iterator().next();
        }
        if ((funct = type.getFunctionOrPointedFunction(additionalPath)) == null && !additionalPath.startsWith("actor")) {
            this.processFunction(functionCall);
            FunctionCall c = new FunctionCall(null, null, null, null, additionalPath, false, true, false, this.getCurrentClauseType() == 53);
            this.addFunctionCall(c);
            return c.getKey();
        }
        Vector<MqlNode> args = new Vector<MqlNode>();
        while (paramNode != null) {
            args.add(paramNode);
            paramNode = (MqlNode)paramNode.getNextSibling();
        }
        FunctionCall c = new FunctionCall(funct, args, null, type, path, inFunctionCall, false, additionalPath.startsWith("actor"), this.getCurrentClauseType() == 53);
        this.addFunctionCall(c);
        if (c.isActorFunction() && c.getPath().startsWith("actor")) {
            this.setActorType(functionCall);
        } else if (!c.isActorFunction() || !c.getPath().startsWith("actor")) {
            // empty if block
        }
        return c.getKey();
    }

    private void addFunctionCall(FunctionCall c) {
        while (this.orderedFunctionCalls.get(c.getKey()) != null) {
            c = c.incrementId();
        }
        this.orderedFunctionCalls.put(c.getKey(), c);
    }

    protected void setBooleanType(AST a) {
        ((MqlNode)a).setMakType(DataDefinitionProvider.getInstance().makeFieldOfType("dummy", "boolean"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void processFunction(AST functionCall) throws SemanticException {
        AST functionNode = functionCall.getFirstChild();
        AST exprList = functionNode.getNextSibling();
        MqlNode paramNode = (MqlNode)exprList.getFirstChild();
        int index = 0;
        String name = functionNode.getText();
        MQLFunctionDefinition functionDef = MQLFunctionDefinition.getByName(MqlNode.mqlFunctions, name);
        if (functionDef == null) {
            throw new ProgrammerError("MQL Function '" + name + "' is not defined as query fragment, nor is it a known MQL function! Please refer to " + LINK_FUNCTION_DEF + " for a list of known functions.");
        }
        Object[] args = functionDef.getArguments();
        if (paramNode == null && !ArrayUtils.isEmpty((Object[])args)) {
            throw new ProgrammerError("The function '" + functionDef + "' requires arguments! Please refer to " + LINK_FUNCTION_DEF + " for a list of known functions and arguments.");
        }
        while (paramNode != null) {
            String type = null;
            if (args == null) throw new ProgrammerError("MQL Function '" + functionDef + "' requires no arguments.");
            if (args.length > index) {
                type = ((MQLFunctionArgument)args[index]).getType();
            } else {
                if (!((MQLFunctionArgument)args[args.length - 1]).isMultiple()) throw new ProgrammerError("The number of arguments for function '" + functionDef + "' is wrong! Please refer to " + LINK_FUNCTION_DEF + " for a list of known functions and arguments.");
                type = ((MQLFunctionArgument)args[args.length - 1]).getType();
            }
            if (paramNode.isParam()) {
                this.setParameterType(paramNode, DataDefinitionProvider.getInstance().makeFieldOfType("dummy", type));
            }
            paramNode = (MqlNode)paramNode.getNextSibling();
            ++index;
        }
    }

    public void reportWarning(String s) {
        System.out.println(s);
    }

    protected void pushFromClause(AST fromClause, AST inputFromNode) {
        QueryContext c = new QueryContext(this);
        c.setParent(this.currentContext);
        if (this.currentContext == null) {
            this.rootContext = c;
        } else {
            this.hasSubqueries = true;
        }
        this.currentContext = c;
    }

    protected void setFromEnded() throws SemanticException {
        this.fromEnded = true;
    }

    protected void processQuery(AST select, AST query) throws SemanticException {
        if (this.error != null) {
            return;
        }
        if (select == null) {
            this.addDefaultProjections(query);
        }
        this.select = query.getFirstChild();
        this.currentContext.close();
        if (!this.currentContext.filters.isEmpty()) {
            this.addFilters(query);
        }
        this.currentContext = this.currentContext.getParent();
    }

    private void addDefaultProjections(AST query) throws SemanticException {
        AST clause = ASTUtil.create(this.fact, 131, "");
        clause.setNextSibling(query.getFirstChild());
        MqlIdentNode lastProjection = null;
        for (String label : this.currentContext.explicitLabels) {
            MqlIdentNode proj = (MqlIdentNode)ASTUtil.create(this.fact, 120, label);
            proj.resolve();
            if (lastProjection == null) {
                clause.setFirstChild((AST)proj);
            } else {
                lastProjection.setNextSibling((AST)proj);
            }
            lastProjection = proj;
        }
        query.setFirstChild(clause);
    }

    private void addFilters(AST query) {
        AST a;
        AST from = query.getFirstChild();
        while (from.getType() != 22) {
            from = from.getNextSibling();
        }
        AST where = from.getNextSibling();
        if (where == null || where.getType() != 53) {
            a = where;
            where = ASTUtil.create(this.fact, 53, "");
            from.setNextSibling(where);
            where.setNextSibling(a);
        }
        a = where.getFirstChild();
        AST filters = ASTUtil.create(this.fact, 140, "");
        where.setFirstChild(filters);
        filters.setNextSibling(a);
        MqlNode lastCond = null;
        for (NameResolver.TextList f : this.currentContext.filters) {
            MqlNode sqlToken = (MqlNode)ASTUtil.create(this.fact, 136, "");
            if (lastCond != null) {
                lastCond.setNextSibling((AST)sqlToken);
            } else {
                filters.setFirstChild((AST)sqlToken);
            }
            lastCond = sqlToken;
            sqlToken.setTextList(f);
        }
    }

    protected AST createFromElement(String path, AST alias, AST propertyFetch) throws SemanticException {
        return this.currentContext.createFromElement(path, alias, 28);
    }

    protected void createFromJoinElement(AST path, AST alias, int joinType, AST fetch, AST propertyFetch, AST with) throws SemanticException {
        if (this.error != null) {
            return;
        }
        if (!(path instanceof MqlDotNode)) {
            throw new SemanticException("can only support dot froms " + path, "", path.getLine(), path.getColumn());
        }
        ((MqlDotNode)path).processInFrom();
        this.currentContext.createFromElement(path.getText(), alias, joinType);
    }

    protected AST lookupProperty(AST dot, boolean root, boolean inSelect) throws SemanticException {
        if (this.error != null || !this.fromEnded) {
            return dot;
        }
        MqlDotNode dotNode = (MqlDotNode)dot;
        dotNode.processInExpression();
        return dot;
    }

    protected void resolve(AST node) throws SemanticException {
        if (this.error != null || !this.fromEnded || this.functionAsInliner && this.inFunctionCall) {
            return;
        }
        if (node.getType() == 120) {
            ((MqlIdentNode)node).resolve();
        }
    }

    protected void setAlias(AST selectExpr, AST ident) {
        if (this.error != null) {
            return;
        }
        MqlNode as = (MqlNode)ASTUtil.create(this.fact, 134, ident.getText());
        selectExpr.setNextSibling((AST)as);
        as.setText(" AS " + as.getText());
        this.currentContext.projectionLabelSearch.put(ident.getText(), (MqlNode)selectExpr);
    }

    protected AST generateNamedParameter(AST delimiterNode, AST nameNode) throws SemanticException {
        MqlNode para = (MqlNode)ASTUtil.create(this.fact, 142, nameNode.getText());
        para.setText("?");
        return para;
    }

    protected AST generatePositionalParameter(AST inputNode) throws SemanticException {
        return ASTUtil.create(this.fact, 117, "?");
    }

    void setParameterType(MqlNode param, FieldDefinition likewise) {
        FieldDefinition fd;
        String paramName = param.getOriginalText();
        int paramPositionIndex = paramName.indexOf("###");
        if (paramPositionIndex < -1) {
            throw new MakumbaError("Untreated parameter " + paramName + " in query analysis");
        }
        int paramPosition = Integer.parseInt(paramName.substring(paramPositionIndex + 3));
        if (!this.multiTypeParams.contains(paramName = paramName.substring(0, paramPositionIndex))) {
            fd = DataDefinitionProvider.getInstance().makeFieldWithName(paramName, likewise);
            FieldDefinition fd1 = this.paramInfoByName.getFieldDefinition(paramName);
            if (fd1 != null && !fd1.isAssignableFrom(fd)) {
                this.multiTypeParams.add(paramName);
            } else if (fd1 == null) {
                this.paramInfoByName.addField(fd);
            }
        }
        fd = DataDefinitionProvider.getInstance().makeFieldWithName("param" + paramPosition, likewise);
        param.setMakType(fd);
        this.paramInfoByPosition.addField(fd);
    }

    void setProjectionTypes(DataDefinition proj) {
        if (this.select == null) {
            return;
        }
        int i = 0;
        for (AST a = this.select.getFirstChild(); a != null; a = a.getNextSibling()) {
            MqlNode mqlNode;
            FieldDefinition makType;
            if (a.getType() == 134) continue;
            String name = "col" + (i + 1);
            if (a.getNextSibling() != null && a.getNextSibling().getType() == 134) {
                name = ((MqlNode)a.getNextSibling()).getOriginalText();
            }
            if ((makType = (mqlNode = (MqlNode)a).getMakType()) == null && mqlNode.isParam()) {
                String paramName = mqlNode.getOriginalText();
                if ((paramName = paramName.substring(0, paramName.indexOf("###"))).startsWith("actor_")) {
                    String type = paramName.substring("actor_".length()).replace("_", ".");
                    makType = DataDefinitionProvider.getInstance().getDataDefinition(type).getFieldDefinition(0);
                    mqlNode.setMakType(makType);
                } else if (!this.multiTypeParams.contains(paramName)) {
                    makType = this.paramInfoByName.getFieldDefinition(paramName);
                }
            }
            if (makType == null && this.insertIn != null && (makType = this.insertIn.getFieldDefinition(name)) != null && mqlNode.isParam()) {
                this.setParameterType((MqlNode)a, makType);
            }
            if (makType == null) {
                throw new IllegalStateException("no type set for projection " + name + " " + MqlQueryAnalysis.showAst(a));
            }
            proj.addField(DataDefinitionProvider.getInstance().makeFieldWithName(name, makType));
            ++i;
        }
    }

    public boolean isAnalysisQuery() {
        if (this.select == null || this.select.getFirstChild() == null) {
            return false;
        }
        return this.select.getFirstChild().getNextSibling() == null && this.select.getFirstChild().getType() == 118;
    }

    protected void setActorType(AST a) {
        String type = ASTUtil.getPath(a.getFirstChild().getNextSibling().getFirstChild());
        DataDefinition typeDD = this.ddp.getDataDefinition(type);
        ((MqlNode)a).setMakType(typeDD.getFieldDefinition(0));
    }
}

